/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.gui.CUIConfigPanel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CUIConfigList
extends class_4265<ConfigEntry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private static final class_2583 invalidFormat = class_2583.field_24360.method_10977(class_124.field_1079).method_30938(Boolean.valueOf(true));
    private final CUIConfiguration configuration;
    int maxNameWidth = 0;

    public static CUIConfigList create(CUIConfigPanel panel, class_310 mc) {
        CUIConfigList list = new CUIConfigList(panel, mc);
        for (String key : list.configuration.getConfigArray().keySet()) {
            Object value = list.configuration.getConfigArray().get(key);
            list.maxNameWidth = Math.max(list.maxNameWidth, mc.field_1772.method_27525((class_5348)list.configuration.getDescription(key)));
            if (value instanceof Boolean) {
                CUIConfigList cUIConfigList = list;
                Objects.requireNonNull(cUIConfigList);
                list.method_25321((class_350.class_351)cUIConfigList.new OnOffEntry(key));
                continue;
            }
            if (value instanceof Colour) {
                CUIConfigList cUIConfigList = list;
                Objects.requireNonNull(cUIConfigList);
                list.method_25321((class_350.class_351)cUIConfigList.new ColorConfigEntry(key));
                continue;
            }
            LOGGER.warn("WorldEditCUI has option {} with unknown data type {}", (Object)key, (Object)(value == null ? "NULL" : value.getClass().getName()));
        }
        return list;
    }

    private CUIConfigList(CUIConfigPanel panel, class_310 minecraft) {
        super(minecraft, panel.field_22789 + 45, panel.field_22790 - 60, 25, 25);
        this.configuration = panel.configuration;
    }

    public int method_25322() {
        return super.method_25322() + 32;
    }

    public class OnOffEntry
    extends ConfigEntry {
        private final class_5676<Boolean> toggleBotton;

        public OnOffEntry(String tag) {
            super(tag);
            Boolean value = (Boolean)CUIConfigList.this.configuration.getConfigArray().get(tag);
            this.toggleBotton = class_5676.method_32614((boolean)value).method_32616().method_32617(0, 0, 70, 20, CUIConfigList.this.configuration.getDescription(tag), (press, boolean_) -> CUIConfigList.this.configuration.changeValue(tag, boolean_));
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.resetButton, this.toggleBotton);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.resetButton, this.toggleBotton);
        }

        @Override
        protected void updateFromConfig() {
            this.toggleBotton.method_32605((Object)((Boolean)CUIConfigList.this.configuration.getConfigArray().get(this.tag)));
        }

        @Override
        public void method_25343(class_332 gfx, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            super.method_25343(gfx, mouseX, mouseY, isMouseOver, partialTick);
            this.toggleBotton.method_46421(CUIConfigList.this.method_25342() + 105);
            this.toggleBotton.method_46419(this.method_46427());
            this.toggleBotton.method_25394(gfx, mouseX, mouseY, partialTick);
        }
    }

    public class ColorConfigEntry
    extends ConfigEntry {
        private final class_342 textField;

        public ColorConfigEntry(String tag) {
            super(tag);
            Colour cValue = (Colour)CUIConfigList.this.configuration.getConfigArray().get(tag);
            this.textField = new class_342(((CUIConfigList)CUIConfigList.this).field_22740.field_1772, 0, 0, 70, 20, (class_2561)class_2561.method_43470((String)cValue.hexString()));
            this.textField.method_1880(9);
            this.textField.method_1852(cValue.hexString());
            this.textField.method_1863(updated -> {
                Colour tested = Colour.parseRgbaOrNull(updated);
                if (tested != null) {
                    CUIConfigList.this.configuration.changeValue(tag, tested);
                }
            });
            this.textField.method_73210((string, integer) -> {
                String colorSource = this.textField.method_1882();
                if (colorSource.length() != 9) {
                    return class_5481.method_30747((String)string, (class_2583)invalidFormat);
                }
                return class_5251.method_27719((String)colorSource.substring(0, 7)).map(color -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360.method_27703(color))).result().orElseGet(() -> class_5481.method_30747((String)string, (class_2583)invalidFormat));
            });
            this.textField.method_1890(value -> {
                if (!value.isEmpty() && value.charAt(0) != '#') {
                    return false;
                }
                for (int i = 1; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                    return false;
                }
                return true;
            });
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.resetButton, (Object)this.textField);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.resetButton, (Object)this.textField);
        }

        @Override
        protected void updateFromConfig() {
            this.textField.method_1852(((Colour)CUIConfigList.this.configuration.getConfigArray().get(this.tag)).hexString());
        }

        @Override
        public void method_25343(class_332 gfx, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            super.method_25343(gfx, mouseX, mouseY, isMouseOver, partialTick);
            this.textField.method_46421(CUIConfigList.this.method_25342() + 105);
            this.textField.method_46419(this.method_46427());
            this.textField.method_25394(gfx, mouseX, mouseY, partialTick);
        }
    }

    public abstract class ConfigEntry
    extends class_4265.class_4266<ConfigEntry> {
        protected final String tag;
        protected final class_4185 resetButton;
        protected final class_7842 textField;

        public ConfigEntry(String tag) {
            this.tag = tag;
            this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controls.reset"), button -> {
                CUIConfigList.this.configuration.changeValue(tag, CUIConfigList.this.configuration.getDefaultValue(tag));
                this.updateFromConfig();
            }).method_46434(0, 0, 50, 20).method_46431();
            this.textField = new class_7842(Objects.requireNonNull(CUIConfigList.this.configuration.getDescription(tag)), ((CUIConfigList)CUIConfigList.this).field_22740.field_1772);
            class_2561 tooltip = CUIConfigList.this.configuration.getTooltip(tag);
            if (tooltip != null) {
                this.textField.method_47400(class_7919.method_47407((class_2561)tooltip));
            }
        }

        public void method_25343(class_332 gfx, int mouseX, int mouseY, boolean hovered, float partialTick) {
            int left = this.method_46426();
            int top = this.method_46427();
            int textLeft = left + 90 - CUIConfigList.this.maxNameWidth;
            this.textField.method_46421(textLeft);
            this.textField.method_46419(top);
            this.textField.method_25394(gfx, mouseX, mouseY, partialTick);
            this.resetButton.method_46421(left + 190);
            this.resetButton.method_46419(top);
            this.resetButton.method_25394(gfx, mouseX, mouseY, partialTick);
        }

        protected abstract void updateFromConfig();
    }
}

