/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.fabric;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.enginehub.worldeditcui.WorldEditCUI;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.event.listeners.CUIListenerChannel;
import org.enginehub.worldeditcui.event.listeners.CUIListenerWorldRender;
import org.enginehub.worldeditcui.fabric.CUINetworking;
import org.enginehub.worldeditcui.protocol.CUIPacket;
import org.enginehub.worldeditcui.protocol.CUIPacketHandler;
import org.enginehub.worldeditcui.render.OptifinePipelineProvider;
import org.enginehub.worldeditcui.render.PipelineProvider;
import org.enginehub.worldeditcui.render.VanillaPipelineProvider;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class FabricModWorldEditCUI
implements ModInitializer {
    private static final int DELAYED_HELO_TICKS = 10;
    public static final String MOD_ID = "worldeditcui";
    private static FabricModWorldEditCUI instance;
    private static final class_304.class_11900 KEYBIND_CATEGORY_WECUI;
    private final class_304 keyBindToggleUI = FabricModWorldEditCUI.key("toggle", -1);
    private final class_304 keyBindClearSel = FabricModWorldEditCUI.key("clear", -1);
    private final class_304 keyBindChunkBorder = FabricModWorldEditCUI.key("chunk", -1);
    private static final List<PipelineProvider> RENDER_PIPELINES;
    private WorldEditCUI controller;
    private CUIListenerWorldRender worldRenderListener;
    private CUIListenerChannel channelListener;
    private class_1937 lastWorld;
    private class_746 lastPlayer;
    private boolean visible = true;
    private int delayedHelo = 0;
    private float lastPartialTicks = 0.0f;

    private static class_304 key(String name, int code) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.worldeditcui." + name, code, KEYBIND_CATEGORY_WECUI));
    }

    public void onInitialize() {
        if (Boolean.getBoolean("wecui.debug.mixinaudit")) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        instance = this;
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        ClientLifecycleEvents.CLIENT_STARTED.register(this::onGameInitDone);
        CUINetworking.subscribeToCuiPacket(this::onPluginMessage);
        ClientPlayConnectionEvents.JOIN.register(this::onJoinGame);
        WorldRenderEvents.END_EXTRACTION.register(ctx -> {
            this.lastPartialTicks = ctx.tickCounter().method_60638();
        });
        WorldRenderEvents.END_MAIN.register(ctx -> {
            try {
                RenderSystem.getModelViewStack().pushMatrix();
                RenderSystem.getModelViewStack().mul((Matrix4fc)ctx.matrices().method_23760().method_23761());
                this.onPostRenderEntities(ctx);
            }
            finally {
                RenderSystem.getModelViewStack().popMatrix();
            }
        });
    }

    private void onTick(class_310 mc) {
        boolean clock;
        CUIConfiguration config = this.controller.getConfiguration();
        boolean inGame = mc.field_1724 != null;
        boolean bl = clock = mc.method_61966().method_60637(false) > 0.0f;
        if (inGame && mc.field_1755 == null) {
            while (this.keyBindToggleUI.method_1436()) {
                this.visible = !this.visible;
            }
            while (this.keyBindClearSel.method_1436()) {
                if (mc.field_1724 != null) {
                    mc.field_1724.field_3944.method_71927("/sel", null);
                }
                if (!config.isClearAllOnKey()) continue;
                this.controller.clearRegions();
            }
            while (this.keyBindChunkBorder.method_1436()) {
                this.controller.toggleChunkBorders();
            }
        }
        if (inGame && clock && this.controller != null) {
            if (mc.field_1687 != this.lastWorld || mc.field_1724 != this.lastPlayer) {
                this.lastWorld = mc.field_1687;
                this.lastPlayer = mc.field_1724;
                this.controller.getDebugger().debug("World change detected, sending new handshake");
                this.controller.clear();
                this.helo(mc.method_1562());
                this.delayedHelo = 10;
                if (mc.field_1724 != null && config.isPromiscuous()) {
                    mc.field_1724.field_3944.method_71927("we cui", null);
                }
            }
            if (this.delayedHelo > 0) {
                --this.delayedHelo;
                if (this.delayedHelo == 0) {
                    this.helo(mc.method_1562());
                }
            }
        }
    }

    private void onPluginMessage(CUIPacket payload, CUIPacketHandler.PacketContext ctx) {
        try {
            ctx.workExecutor().execute(() -> this.channelListener.onMessage(payload));
        }
        catch (Exception ex) {
            this.getController().getDebugger().info("Error decoding payload from server", ex);
        }
    }

    public void onGameInitDone(class_310 client) {
        this.controller = new WorldEditCUI();
        this.controller.initialise(client);
        this.worldRenderListener = new CUIListenerWorldRender(this.controller, client, RENDER_PIPELINES);
        this.channelListener = new CUIListenerChannel(this.controller);
    }

    public void onJoinGame(class_634 handler, PacketSender sender, class_310 client) {
        this.visible = true;
        this.controller.getDebugger().debug("Joined game, sending initial handshake");
        this.helo(handler);
    }

    public void onPostRenderEntities(WorldRenderContext ctx) {
        if (this.visible) {
            this.worldRenderListener.onRender(this.lastPartialTicks);
        }
    }

    private void helo(class_634 handler) {
        CUINetworking.send(new CUIPacket("v", new String[]{CUIPacket.protocolVersion()}));
    }

    public WorldEditCUI getController() {
        return this.controller;
    }

    public static FabricModWorldEditCUI getInstance() {
        return instance;
    }

    static {
        KEYBIND_CATEGORY_WECUI = new class_304.class_11900(class_2960.method_60655((String)MOD_ID, (String)"general"));
        RENDER_PIPELINES = List.of(new OptifinePipelineProvider(), new VanillaPipelineProvider());
    }
}

